package xippeeWin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;

public class Debug {
	private static File info;
	private static FileWriter writer;
	private static PrintWriter debugWriter;
	private PrintWriter configWriter;
	private boolean RECORD = false;
	public final static boolean MODE = false;
	private PrintStream console;

	Debug(boolean mode) {
		RECORD = mode;
		if(RECORD)	
			try {
				File dir = new File(WINCommands.appdataPath() +"\\Xippee");
				if(!dir.isDirectory() && !dir.isFile())
					dir.mkdir();
				info = new File(WINCommands.appdataPath() + "\\Xippee\\debug.info");

				writer = new FileWriter(info);
				debugWriter = new PrintWriter(writer,true);
				info = new File(WINCommands.appdataPath() + "\\Xippee\\Xippee.ini");
				writer = new FileWriter(info);
				configWriter = new PrintWriter(writer,true);
				// out = this.getClass().getResourceAsStream("debug");
				debugWriter.println(new Date().toString());
				configWriter.println(new Date().toString());
			} catch (IOException e) {
				RECORD = false;
				e.printStackTrace();
			

		}
	}

	public void record(String[] args) {
		if (RECORD) {
			String temp ="";
			for (int i = 0; i < args.length; i++) {
				temp = temp + args[i] + " ";
			}
			this.record(temp);
		}
	}

	public void record(String args) {
		if (RECORD) {
			//System.out.println(args);
			debugWriter.println(args);
		}
	}

	public void close() {
		if (RECORD){
			debugWriter.close();
			configWriter.close();
			console.close();
		}
	}

	public void writeToConfig(String s) {
		if(RECORD)
			configWriter.println(s);
	}

	protected void finalize() throws Throwable {
		try {
			this.close(); // close open files
		} finally {
			super.finalize();
		}
	}

}
