﻿Imports System.Xml
Imports System.Security.Cryptography.X509Certificates

Partial Public Class TestXSignFF
    Inherits System.Web.UI.Page

    Private Function CheckSignature(ByVal signedxmldata As String) As Boolean
        Dim xdoc As New XmlDocument()
        xdoc.LoadXml(signedxmldata)
        xdoc.GetElementsByTagName("Signature")(0).ParentNode.RemoveChild(xdoc.GetElementsByTagName("Signature")(0))

        Dim sxmlDocument As New XmlDocument()
        sxmlDocument.LoadXml(signedxmldata)

        Dim signedXml As New System.Security.Cryptography.Xml.SignedXml(xdoc)
        signedXml.LoadXml(sxmlDocument.GetElementsByTagName("Signature")(0))

        'To get the signing certificate info
        Dim base64cert As String = signedXml.KeyInfo.GetXml().GetElementsByTagName("X509Certificate")(0).InnerText
        Dim cert As New X509Certificate2(Convert.FromBase64String(base64cert))
        'Do something with cert

        Return signedXml.CheckSignature

        'If you want to use existing certificate (publik key) to check the signature
        'Dim cert As X509Certificates.X509Certificate2 = GetCertificate()
        'Return signedXml.CheckSignature(cert, True)
    End Function

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Try
            'Load some XML document (you can also use serialized XML document)
            Dim xml As New System.Xml.XmlDocument
            xml.Load(Server.MapPath("~\PaymentInfo.xml"))

            Me.lblXml.Text = Server.HtmlEncode(xml.OuterXml)

            'Sote XML in hidden field
            hiddenXml.Value = xml.OuterXml
        Catch ex As Exception
            lblXml.Text = ex.ToString()
        End Try
    End Sub

    Protected Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Try
            Dim xml As New XmlDocument
            xml.LoadXml(hiddenSignedXml.Value)

            Me.lblSignedXml.Text = Server.HtmlEncode(xml.OuterXml)

            If CheckSignature(xml.OuterXml) Then
                Me.lblsignatureValidation.Text = "Valid signature"
            Else
                Me.lblsignatureValidation.Text = "Invalid signature"
            End If
        Catch ex As Exception
            lblsignatureValidation.Text = ex.ToString()
        End Try
    End Sub

End Class