<?xml version='1.0' encoding='utf-8'?>
<!--
Copyright 2007, ZipoSoft, Inc. (Acme Device Drivers, Inc.)

This file is part of ZipoBase, from ZipoSoft. See ZipoBase.com for more infomation

THIS CODE IS PROVIDED "AS IS". ZIPOSOFT MAKES NO WARRANTIES, EXPRESSED,
IMPLIED OR OTHERWISE, REGARDING ITS ACCURACY, COMPLETENESS OR PERFORMANCE.
-->

<!DOCTYPE xsl:stylesheet [
  <!ENTITY loz "&#9674;">
  <!ENTITY empty "&#664;">
  <!ENTITY times "&#215;">
  <!ENTITY Xi "&#926;">
  <!ENTITY space "&#160;">
  <!ENTITY bull "&#9679;">
  <!ENTITY arw_left   "&#8592;">
  <!ENTITY arw_right  "&#8594;">
  <!ENTITY arw_down   "&#8595;">
  <!ENTITY arw_up     "&#8593;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd" method="html"/>

  <xsl:template match="page">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <link rel="icon" href="../favicon.ico" type="image/x-icon" />
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
        <title>
          ZipoBase<!--         <xsl:value-of select="@title"/>-->
        </title>
        <meta name="description" content="ZipoBase" />
        <meta name="keywords" content="simple, fast, database" />
        <style type="text/css">
          @import url(../ZipoBase.css);
          <!-- @import url(../<xsl:value-of select="@browser"/>);-->
        </style>
        <script type="text/javascript" src="../ZipoBase.js"> </script>
        <!-- IE cant handle empy script elm-->

      </head>
      <body >
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>


  <xsl:template match="int">
    <table cellpadding="0" cellspacing="0" height="100%"  >
      <!---->
      <xsl:apply-templates select="@*" />
      <xsl:apply-templates select ="titlebar"/>
      <tr>
        <td>
          <table>
            <tr>
              <td style="vertical-align:top; ">
                <table>
                  <xsl:apply-templates select ="menubar"/>
                  <tr>
                    <td>
                      <table cellpadding="0" cellspacing="0" style="margin-bottom:0;border-collapse:separate" >
                        <tr>
                          <xsl:apply-templates select="sub/tab"/>
                          <xsl:apply-templates select="side/tab"/>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  <xsl:apply-templates select ="msg"/>
                  <xsl:apply-templates select ="errmsg"/>
                  <xsl:apply-templates select ="main"/>
                </table>
              </td>
              <xsl:for-each select="side/int">
                <td >
                  <xsl:attribute name="class">
                    <xsl:value-of select="@class"/>
                  </xsl:attribute>
                  <xsl:apply-templates select="self::int"/>
                </td>
              </xsl:for-each>
            </tr>

          </table>
        </td>
      </tr>
      <tr>
        <td width="100%">
          <table width="100%">
            <tr>
              <xsl:for-each select="sub/int">
                <td >
                  <xsl:attribute name="class">
                    <xsl:value-of select="@class"/>
                  </xsl:attribute>
                  <xsl:apply-templates select="self::int"/>
                </td>
              </xsl:for-each>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>
  <xsl:template match="tab">
    <td class="tab"  >
      <table >
        <tr>
          <xsl:for-each select="*">
            <td >
              <xsl:apply-templates select="self::*"/>
            </td>
              </xsl:for-each>
        </tr>
      </table>
    </td>
  </xsl:template>

  <xsl:template match="titlebar">
    <tr>
      <td class="titlebar" >
        <table class="titlebar">
          <tr>
            <xsl:for-each select="*">
              <td >
                <xsl:attribute name="class">
                  <!-- <xsl:value-of select="name()"/>-->
                  <xsl:value-of select="@class"/>
                </xsl:attribute>
                <xsl:apply-templates select="self::*"/>
              </td>
            </xsl:for-each>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="title">
    <a class="title">
      <xsl:apply-templates select="@*" />
      <xsl:value-of select="."/>
    </a>
  </xsl:template>

  <xsl:template match="tb_link">
    <a class="tb_link">
      <xsl:apply-templates select="@*" />
      <xsl:value-of select="."/>
    </a>
  </xsl:template>
  <xsl:template match="tb_butt">
    <a class="tb_butt">
      <xsl:apply-templates select="@*" />
      <xsl:value-of select="."/>
    </a>
  </xsl:template>

  <xsl:template match="msg">
    <tr>
      <td class="msg" >
        <p class="msg">
        <xsl:value-of select="."/></p>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="errmsg">
    <tr>
      <td class="errmsg" >
        <xsl:value-of select="."/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="main">
    <tr>
      <td class="intmain" >
        <xsl:apply-templates/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="children">
    <xsl:apply-templates/>
  </xsl:template>
  <xsl:template match="tabs">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>

  <xsl:template match="menubar">
    <tr>
      <td class="menubar">
        <table cellspacing="0" cellpadding="0">
          <tr>
            <xsl:apply-templates/>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="menuitem">
    <tr>
      <td class="menuitem"  onmouseover="menuitem_hi(this)" onmouseout="menuitem_low(this)">
        <xsl:attribute name="onclick">
          location.href='<xsl:value-of select="@href"/>'
        </xsl:attribute>
        <a class="menuitem">
          <xsl:apply-templates select="@*" />
          <xsl:value-of select="."/>
        </a>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="menubar_button" >
    <td class="menutop" >
      <a class="menubar_button">
        <xsl:apply-templates select="@*" />
        <xsl:value-of select="."/>
      </a>
    </td>
  </xsl:template>
  <xsl:template match="menuslot">
    <tr>
      <td >
        <xsl:apply-templates/>
      </td>
    </tr>
  </xsl:template>
  <xsl:template match="menusub">
    <tr>
      <td class="menuitemsub" onmouseover="showsubmenu(this);" onmouseout="hidesubmenu(this);">
        <xsl:value-of select="@title"/>
        <table class="menusub" cellspacing="0" cellpadding="0">
          <xsl:apply-templates/>

        </table>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="menu">
    <td class="menutop" align="left" onmouseover="showmenu(this);" onmouseout="hidemenu(this);">
      <xsl:value-of select="@title"/>
      <div style="display:block;">
        <table class="menu" cellspacing="0" cellpadding="0">
          <xsl:apply-templates/>
        </table>
      </div>
    </td>
  </xsl:template>

  <xsl:template match="tablelist">
    <div class="tablelist">
      <table class="tablelist" cellpadding="3" >
        <xsl:apply-templates/>

      </table>
    </div>
  </xsl:template>

  <xsl:template match="tl_head">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>

  <xsl:template match="tl_sort">
    <th class="tl_sort" >
      <xsl:attribute name="title">
        Sort by:
        <xsl:value-of select="."/>
      </xsl:attribute>
      <a>
        <xsl:attribute name="href">
          <xsl:value-of select="@href"/>
        </xsl:attribute>
        <xsl:value-of select="."/>
      </a>
    </th>
  </xsl:template>

  <xsl:template match="tl_col">
    <th class="tl_col">
      <xsl:apply-templates/>
    </th>
  </xsl:template>
  <xsl:template match="tl_pagedown">
    <tr class="rowclick" ONMOUSEOVER="this.className='tl_row_hi'"
ONMOUSEOUT="this.className='tl_row'">
      <xsl:attribute name="onclick">
        location.href='<xsl:value-of select="@href"/>'
      </xsl:attribute>
      <td style="color:blue; text-align:center" >
        <xsl:attribute name="colspan">
          <xsl:value-of select="@colspan"/>
        </xsl:attribute>
        &arw_down;&space;<xsl:value-of select="."/>&space;&arw_down;
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="tl_row">
    <tr class="rowclick" ONMOUSEOVER="this.className='tl_row_hi'"
    ONMOUSEOUT="this.className='tl_row'">
      <xsl:attribute name="onclick">
        location.href='<xsl:value-of select="tl_key/@href"/>'
      </xsl:attribute>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>
  <xsl:template match="tl_c">
    <td class="tl_c">
      <xsl:apply-templates/>
    </td>
  </xsl:template>

  <xsl:template match="tl_key">
    <td class="tl_key">
      <a>
        <xsl:attribute name="title">
          View Record#
          <xsl:value-of select="."/>
        </xsl:attribute>
        <xsl:attribute name="href">
          <xsl:value-of select="@href"/>
        </xsl:attribute>
        <xsl:value-of select="."/>
      </a>
    </td>
  </xsl:template>
  <xsl:template match="tl_delkey">
    <td class="tl_key">
      <a>
        <xsl:attribute name="title">
          Delete Record#
          <xsl:value-of select="."/>
        </xsl:attribute>
        <xsl:attribute name="href">
          <xsl:value-of select="@href"/>
        </xsl:attribute>
        DEL
      </a>
    </td>
  </xsl:template>
  <xsl:template match="dbg_node">
    <table class="dbg_node" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <td class="dbg_node" colspan="2" >
          <xsl:value-of select="@name"/>
        </td>
      </tr>
      <tr>
        <td class="dbg_node">&space;</td>
        <td class="dbg_node">
          <table class="dbg_node" >
            <xsl:apply-templates select="dbg_var"/>
          </table>
        </td>
      </tr>
      <xsl:for-each select="dbg_node">
        <tr>
          <td class="dbg_node">&space;</td>
          <td class="dbg_subnode">
            <xsl:apply-templates select="self::dbg_node"/>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="dbg_var">
    <tr>
      <td class="dbg_var">
        <xsl:value-of select="@name"/>
      </td>
      <td class="dbg_var_val">
        <xsl:value-of select="@val"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="form">
    <form>
      <xsl:apply-templates select="@*" />
      <table class="recview" cellpadding="3" cellspacing="3" border="1" >
        <xsl:apply-templates />
        <tr>
          <td></td>
          <td>
            <input type="submit" value="save" class="form"/>
          </td>
        </tr>
      </table>
    </form>
  </xsl:template>
  <!--
  <xsl:template match="form_row">
    <tr>
      <xsl:apply-templates select="@*" />
         <td>
           <xsl:apply-templates select="@label" />
         </td>
          <td>
            <xsl:apply-templates />
          </td>
        </tr>
    
  </xsl:template>-->
  <xsl:template match="inputh">
    <input>
      <xsl:apply-templates select="@*" />
      <xsl:attribute name="value">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </input>
  </xsl:template>
  <xsl:template match="new_account">
    <input type="checkbox">
      <xsl:apply-templates select="@*" />
      <xsl:attribute name="onclick">
        showhide('pwd_vfy',this.checked)
      </xsl:attribute>
    </input>
  </xsl:template>
  <xsl:template match="pwd_vfy">
    <input type="text">
      <xsl:apply-templates select="@*" />
      <xsl:attribute name="id">pwd_vfy</xsl:attribute>
    </input>
  </xsl:template>
  <xsl:template match="recview">
    <table class="recview" cellpadding="3" cellspacing="3" border="1" >
      <xsl:apply-templates />
    </table>
  </xsl:template>

  <xsl:template match="rec_row">
    <tr>
      <xsl:apply-templates select ="rec_label"/>
      <xsl:apply-templates select ="rec_val"/>
    </tr>
  </xsl:template>

  <xsl:template match="rec_val">
    <td class="rec_val">
      <xsl:apply-templates />
    </td>
  </xsl:template>
  <xsl:template match="rec_label">
    <td class="rec_label">
      <xsl:apply-templates />
    </td>
  </xsl:template>
  <xsl:template match="xbox_ie">
    <div style="font-family:Wingdings;"></div>
  </xsl:template>


  <xsl:template match="*">
    <xsl:copy-of select="."/>
  </xsl:template>


  <xsl:template match="@*">
    <xsl:copy-of select="."/>
  </xsl:template>


</xsl:stylesheet>
